<?php
//-----------------------------------------------------------------------
// <copyright file="HIPAASpace.WebService.php" company="HIPAA Space">
//      Copyright (c) HIPAA Space. All rights reserved.
//		When code is copied, reference to www.HIPAASpace.com is mandatory
// </copyright>
//-----------------------------------------------------------------------


//******************************
//* Helper classes declarations
//******************************

// Class implements the QueryField container, which is used in ValidateNPI method to pass the comparison field name, value
// and indication whether comparison must be done strictly or not
class QueryField
{
	public $npifield;
	public $comparisonValue;
	public $isExactMatch;

	public function __construct(/* string */ $npifield, /* string */ $comparisonValue, /* bool */ $isExactMatch)
	{
		$this->npifield = $npifield;
		$this->comparisonValue = $comparisonValue;
		$this->isExactMatch = $comparisonValue;
	}

	public function toArray()
	{
		return array('Field' => $this->npifield, 'ComparisonValue' => $this->comparisonValue, 'IsExactMatch' => $this->isExactMatch);
	}

	public static function getArray(/* string */ $npifield, /* string */ $comparisonValue, /* bool */ $isExactMatch)
	{
		$instance = new QueryField($npifield, $comparisonValue, $isExactMatch);
		return $instance->toArray();
	}
}

// Web Service wrapper, that calls SOAP client inside, passing necessary security token
class HIPAASpaceWebService
{
	private $soapClient;
	// This is a test security token. It gives fake information in query methods. In order to obtain your free real token,
	// register at www.HIPAASpace.com/myaccount/default.aspx and paste it here
	//private $securityToken = "3932f3b0-cfab-11dc-95ff-0800200c9a663932f3b0-cfab-11dc-95ff-0800200c9a66";
	private $securityToken = "7599F87B9D2E4754BEC79F4688348DE6D9B2F0CDE1C14BBE816BA8415BD26140";

	public function checkError($result)
	{
		if (isset($result->Error))
		{
			echo "ERROR: ".$result->Error."\n";
			echo "Execution interrupted";
			exit(1);
		}		
		else
		{
			return $result;
		}
	}

	// Makes a free form search and returns up to 30 results with summary information for every item
	public function query(/* string */ $queryType, /* string */ $searchQuery)
	{
		$result = $this->soapClient->Query(array(
			"Type" => $queryType, 
			"QueryString" => $searchQuery, 
			"Token" => $this->securityToken));
		return $this->checkError($result);
	}
	
	// Makes a free form search and returns up to 30 results using queryNPI method
	public function queryNpi(/* QueryField[] */ $criteriaFields, /* int */ $pageNo, /* int */ $pageSize)
	{
		$result = $this->soapClient->QueryNPI(array(
			"criteriaFields" => $criteriaFields, 
			"pageNo" => $pageNo, 
			"pageSize" => $pageSize,
			"token" => $this->securityToken));
		return $this->checkError($result);
	}

	// Returns full details about specific code, including all possible fields
	public function queryItem(/* string */ $queryType, /* string */ $key)
	{
		$result = $this->soapClient->QueryItem(array(
			"Type" => $queryType, 
			"SearchRequest" => $key, 
			"Token" => $this->securityToken));
		return $this->checkError($result);
	}

	// Validates the given NPI along with the fields that are passed with it against the same information in DB. 
	// Result is boolean
	public function validateNPI(/* string */ $npi, /* QueryField [] */ $queryFieldsArray)
	{
		$result = $this->soapClient->ValidateNPI(array(
			"npi" => $npi,
			"compareFields" => $queryFieldsArray, 
			"token" => $this->securityToken));
		return $this->checkError($result) && $result->ValidateNPIResult == true;
	}

	public function __construct() 
	{
		$this->soapClient = new SoapClient("http://www.hipaaspace.com/wspHVLookup.asmx?WSDL");
	}

	public function dumpResults($webServiceResultArray)
	{
		foreach($webServiceResultArray as $result)
		{
			$this->dumpResultItem($result);
		}
	}

	public function dumpResultItem($webServiceResultItem)
	{
		echo "Key:".$webServiceResultItem->Key."\n";
		echo "Properties:\n";
		foreach($webServiceResultItem->ResultSet->Pair as $pair)
		{
			if ($pair->Value != "")
			{
				echo "\t[".$pair->Name."]=[".$pair->Value."]\n";
			}
		}
	}
}

//******************************
//* Test execution
//******************************

echo "****  Testing Query Method   ****\n\n";
$webserviceClient = new HIPAASpaceWebService();
$response = $webserviceClient->query("NPI", "Chen Van");
$webserviceClient->dumpResults($response->QueryResult->WebServiceResult);

echo "\n\n****  Testing QueryItem Method   ****\n\n";
$response = $webserviceClient->queryItem("NPI", "1295798213");
$webserviceClient->dumpResultItem($response->QueryItemResult);

echo "\n\n****  Testing QueryNPI Method   ****\n\n";
$response = $webserviceClient->queryNPI(array(
		QueryField::getArray("LastName", "CHEN", true),
		QueryField::getArray("FirstName", "EMILY", false)
	), 1, 10);
$webserviceClient->dumpResults($response->QueryNPIResult->WebServiceResult);

echo "\n\n****  Testing ValidateNPI Method   ****\n\n";
$response = $webserviceClient->validateNPI("1215930367", array(
		QueryField::getArray("LastName", "GRESSOT", true),
		QueryField::getArray("FirstName", "LAURENT", true)
	));

if ($response == true)
{
	echo "Verification of NPI 1215930367 succeeded";
}
else
{
	echo "Verification of NPI 1215930367 FAILED";
}

?>