#-----------------------------------------------------------------------
# <copyright file="PytonExample.py" company="HIPAASpace">
#      Copyright (c) HIPAASpace. All rights reserved.
#		When code is copied, reference to www.HIPAASpace.com is mandatory
# </copyright>
#-----------------------------------------------------------------------

import urllib.parse
import urllib.request
import sys
from xml.dom.minidom import parse, parseString

#******************************
#* Helper class declaration
#******************************

# Web Service wrapper, that calls RESTful API inside, passing necessary security token
class HIPAASpaceWebService:

    # This is a test security token. It gives fake information in query methods. In order to obtain your free real token,
    # register at www.HIPAASpace.com/myaccount/default.aspx and paste it here
    SECURITY_TOKEN = "3932f3b0-cfab-11dc-95ff-0800200c9a663932f3b0-cfab-11dc-95ff-0800200c9a66"

    # URL to the HIPAASpace RESTful Web Services endpoint
    uri = "http://hipaaspace.com/api/{0}/{1}"

    # Verifies whether the Web Service method returned an error
    def checkError(self, result):
        if (result == ""):
            return "Error: no result was returned for the query"
        xmlDom = parseString(result)
        
        if (xmlDom.documentElement.tagName == "error"):
            return "Error '" + self.data(xmlDom.documentElement, "message") + "': " + self.data(xmlDom.documentElement, "details")
        
        return result

    # Makes a free form search and returns up to 30 results with summary information for every item
    def query(self, queryType, searchQuery):
        # Defining the query parameters such as query, result type, security token
        params = urllib.parse.urlencode({'q': searchQuery, 'rt': 'minxml', 'token': self.SECURITY_TOKEN})
        localUri = self.uri.replace('{0}', queryType).replace('{1}', 'search') + '?' + params
        req = urllib.request.Request(localUri)
        response= urllib.request.urlopen(req)        
        strResponse = response.readlines()[0].decode("ascii")
        return self.checkError(strResponse)

    # Returns full details about specific code, including all possible fields
    def queryItem(self, queryType, key):
        params = urllib.parse.urlencode({'q': key, 'rt': 'minxml', 'token': self.SECURITY_TOKEN})
        localUri = self.uri.replace('{0}', queryType).replace('{1}', 'getcode') + '?' + params
        req = urllib.request.Request(localUri)
        response = urllib.request.urlopen(req)
        strResponse = response.readlines()[0].decode("ascii")
        return self.checkError(strResponse)

    # Dumps all found entries to the screen one by one
    def dumpResults(self, result):
        xmlDom = parseString(result)

        children = self.children(xmlDom.documentElement)
        for npi in children:
            if (npi.nodeName == "NPI"):
                self.dumpResultItemXml(npi)

    # Dumps a single XMLElement entry to the screen
    def dumpResultItemXml(self, resultItem):
        print("Key: " + self.data(resultItem, "NPI"))
        print("Properties:")
        for prop in resultItem.childNodes:
            print("\t" + prop.nodeName + " : " + self.data(resultItem, prop.nodeName))

    # Dumps a single string entry to the screen
    def dumpResultItem(self, resultItem):
        xmlDom = parseString(resultItem)
        self.dumpResultItemXml(self.children(xmlDom.documentElement)[0])
    
    #***************
    # Methods for fast XML DOM structure access
    # **************
    def children(self, parent):
        return parent.childNodes

    def child(self, parent, tagName):
        return parent.getElementsByTagName(tagName)[0]

    def data(self, parent, tagName):
        return self.child(parent, tagName).childNodes[0].data    

#******************************
#* Test execution
#******************************
try:
    wsClient = HIPAASpaceWebService()

    print("****  Testing Query Method   ****\n")
    result = wsClient.query("NPI", "James Smith Dentist")
    wsClient.dumpResults(result)

    print("\n\n****  Testing QueryItem Method   ****\n")
    result = wsClient.queryItem("NPI", "1023271673")
    wsClient.dumpResultItem(result)    

except Exception as exc:
    print("Exception: " + exc.args[0])

print("Tests complete")