#-----------------------------------------------------------------------
# <copyright file="HIPAASpace.WebService.rb" company="HIPAA Space">
#      Copyright (c) HIPAA Space. All rights reserved.
#		When code is copied, reference to www.HIPAASpace.com is mandatory
# </copyright>
#-----------------------------------------------------------------------

require 'rubygems'
gem "soap4r"
require "soap/wsdlDriver"


#******************************
#* Helper classe declarations
#******************************

# Web Service wrapper, that calls SOAP client inside, passing necessary security token
class HIPAASpaceWebService
	# This is a test security token. It gives fake information in query methods. In order to obtain your free real token,
	# register at www.HIPAASpace.com/myaccount/default.aspx and paste it here
	SECURITY_TOKEN = "3932f3b0-cfab-11dc-95ff-0800200c9a663932f3b0-cfab-11dc-95ff-0800200c9a66"
	URL = 'http://www.HIPAASpace.com/wspHVLookup.asmx?WSDL'
	@@driver = SOAP::WSDLDriverFactory.new(URL).create_rpc_driver

	# Verifies whether the Web Service method returned an error
	def checkError(result)
		if result.respond_to?('error')
			puts "Error: " + result.error
			raise "Execution interrupted"
		else
			return result
		end
	end

	# Makes a free form search and returns up to 30 results with summary information for every item
	def query(queryType, searchQuery)
		params = {
			'Type' => queryType,
			'QueryString' => searchQuery,
			'Token' => SECURITY_TOKEN
		}
		wsResult = @@driver.Query(params)
		return checkError(wsResult)
	end

	# Returns full details about specific code, including all possible fields
	def queryItem(queryType, key)
		params = {
			"Type" => queryType,
			"SearchRequest" => key,
			"Token" => SECURITY_TOKEN
		}
		wsResult = @@driver.QueryItem(params)
		return checkError(wsResult)
	end

	# Validates the given NPI along with the fields that are passed with it against the same information in DB.
	# Result is boolean
	def validateNPI(npi, queryFieldsArray)
		#puts @@driver.public_methods
		params = {
			"npi" => npi,
			"compareFields" => queryFieldsArray,
			"token" => SECURITY_TOKEN
		}
		wsResult = @@driver.ValidateNPI(params)
		return checkError(wsResult)
	end

	# Dumps the result array to the screen
	def dumpResults(wsResultArray)
		wsResultArray.each do |wsItem|
			dumpResultItem(wsItem)
		end
	end

	# Dumps single result item to the screen
	def dumpResultItem(wsResultItem)
		puts "Key: " + wsResultItem.key
		puts "Properties:"
		wsResultItem.resultSet.pair.each do |wsResultItem|
			if wsResultItem.value != ""
				puts "\t[" +  wsResultItem.name + "]=[" + wsResultItem.value + "]\n"
			end
		end
	end
end

#******************************
#* Test execution
#******************************
begin
	wsClient = HIPAASpaceWebService.new

	puts "****  Testing Query Method   ****\n"
	result = wsClient.query("NPI", "James Smith Dentist")
	wsClient.dumpResults(result.queryResult.webServiceResult)

	puts "\n\n****  Testing QueryItem Method   ****\n"
	result = wsClient.queryItem("NPI", "1023271673")
	wsClient.dumpResultItem(result.queryItemResult)

	puts "\n\n****  Testing ValidateNPI Method   ****\n"

	result = wsClient.validateNPI("1215930367", [
		{ "Field" => "LastName", "ComparisonValue" => "GRESSOT", "IsExactMatch" => "true" },
		{ "Field" => "FirstName", "ComparisonValue" => "LAURENT", "IsExactMatch" => "true" },
	])

	if result.validateNPIResult == "true"
		puts "Verification of NPI 1215930367 succeeded";
	else
		puts "Verification of NPI 1215930367 FAILED"
	end

rescue => err
	puts "Exception: " + err.message
end