﻿Public Class MainForm

	Dim codeTypes() As String = {"NPI", "HCPCS", "CLIA", "NDC", "HPTC", "NAICS", "ICD10"}

	Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
		Close()
	End Sub

	Private Sub MainForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		comboType.SelectedIndex = 0
	End Sub

	Private Sub ReportResult(ByVal result As HIPAASpace.WebServiceResult, ByVal textBox As TextBox)
		textBox.Text += "=======================================" + Environment.NewLine
		textBox.Text += "Code: " + result.Key + Environment.NewLine

		Dim idx As Integer
		For idx = 0 To result.ResultSet.Length - 1
			If (result.ResultSet(idx).Value <> String.Empty) Then
				textBox.Text += "    [" + result.ResultSet(idx).Name + "] = " + result.ResultSet(idx).Value + Environment.NewLine
			End If
		Next idx

		textBox.Text += Environment.NewLine
	End Sub

	Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
		Cursor = Cursors.WaitCursor

		Dim client As New HIPAASpace.wspHVLookupSoapClient()
		Dim errorMessage As String
		Dim wsResultArray() As HIPAASpace.WebServiceResult = client.Query(codeTypes(comboType.SelectedIndex), textQuery.Text, textToken.Text, errorMessage)

		textResults.Text = String.Empty
		Dim idx As Integer
		For idx = 0 To wsResultArray.Length - 1
			ReportResult(wsResultArray(idx), textResults)
		Next idx

		Cursor = Cursors.Arrow
	End Sub

	Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
		Cursor = Cursors.WaitCursor

		Dim client As New HIPAASpace.wspHVLookupSoapClient()
		Dim errorMessage As String
		Dim result As HIPAASpace.WebServiceResult = client.QueryItem(codeTypes(comboType.SelectedIndex), textCode.Text, textToken.Text, errorMessage)

		textCodeDetails.Text = String.Empty
		ReportResult(result, textCodeDetails)

		Cursor = Cursors.Arrow
	End Sub
End Class